using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml;
using System.Xml.Linq;
using System.Threading;
using System.Windows.Browser;

namespace Sample1
{
    public partial class Page : UserControl
    {
        public delegate void nextDelegate();

        public Page()
        {
            InitializeComponent();
            myStoryboard.Begin();

            WebClient wc = new WebClient();
            wc.DownloadStringAsync(new Uri("http://dynamic.rakuten.co.jp/rcm/1.0/i/rest?developerId=デベロッパーＩＤ&affiliateId=アフィリエイトＩＤ&url="+HtmlPage.Document.DocumentUri.ToString()));
            wc.DownloadStringCompleted += new DownloadStringCompletedEventHandler(wc_DownloadStringCompleted);
        }

        void wc_DownloadStringCompleted(object sender, DownloadStringCompletedEventArgs e)
        {
            int ItemNum = 0;
            XDocument root = XDocument.Parse(e.Result);

            IEnumerable<XElement> elem =
                from el in root.Elements().Elements().Elements().Elements()
                select el;
            foreach (XElement item in elem)
                if (item.Name.LocalName == "Ad")
                {
                    ItemNum++;
                    adItemDisplay adBox = (adItemDisplay)FindName("adItem" + ItemNum);
                    IEnumerable<XElement> itemInfos =
                        from itemInfo in item.Elements()
                        select itemInfo;
                    foreach (XElement info in itemInfos)
                    {
                        switch (info.Name.LocalName)
                        {
                            case "ItemName":
                                adBox.textBox.Text = info.Value;
                                break;
                            case "MediumImageUrl":
                                Uri uri = new Uri(info.Value, UriKind.Absolute);
                                adBox.imageBox.Source = new BitmapImage(uri);
                                break;
                            case "AffiliateItemUrl":
                                adBox.linkButton.NavigateUri = new Uri(info.Value);
                                break;
                        }
                    }
                }
        }
    }
}
