﻿/*
●flikrConnect
*/

package util {
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.net.URLLoader;
	import flash.net.URLRequest;

	public class FlickrConnect extends EventDispatcher{
		/**
		 * property*******************************************************************************
		 */

		private var APIkey:String;
		private var searchUrl:String;
		
		private var tags:String;
		private var photoSize_obj:Object;
		private var startPage:uint = 1;
		private var pageValue:uint = 100;
		
		private var imageUrl_arr:Array;
		private var listData_obj:Object;
		
		private var count:uint;
		private var maxCount:uint;
		
		public static const URL_SET_COMPLETE:String = "URL_SET_COMPLETE";
		public static const USER_SET_COMPLETE:String = "USER_SET_COMPLETE";
		
		/**
		 * constructor**************************************************************************
		 * @param	__api		APIkey
		 */
		public function FlickrConnect(__api:String){
			APIkey = __api;
			
			init();
		}
		
		/**
		 * function*****************************************************************************
		 */
		
		/**
		 * 初期化
		 */
		private function init():void{
			listData_obj = new Object();
			photoSize_obj = { square:"_s", thum:"_t", small:"_m", midium:"", large:"_b" };
			//setXmlLoad();
		}
		
		/**
		 * 検索開始
		 * @param	__str		検索文字列
		 */
		public function search(__str:String):void{
			//検索文字列
			if(__str == ""){
				tags = "japan";
			}else{
				tags = __str;
			}
			
			setSearchUrlString();
			setXmlLoad();
		}
		
		/**
		 * 検索先url構築
		 */
		private function setSearchUrlString():void{
			var baseUrl:String = "http://api.flickr.com/services/rest/?method=flickr.photos.search&api_key="+APIkey;
			searchUrl = baseUrl + "&tags="+ tags + "&page="+startPage+"&per_page="+pageValue;
		}
		
		/**
		 * XMLのロード
		 */
		private function setXmlLoad():void{
			var request:URLRequest = new URLRequest(searchUrl);
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE,xmlLoadComplete);
			loader.load(request);
		}
		
		//
		/**
		 * XMLロード完了後
		 * @param	ev		イベント
		 */
		private function xmlLoadComplete(ev:Event):void{
			var loader:URLLoader = URLLoader(ev.target);
			var xmlData = XML(loader.data);
			
			imageUrl_arr = new Array();
			var xmlList:XMLList = xmlData.photos.photo;
			var length:int = xmlList.length();
			
			listData_obj.page = xmlData.photos.@page;
			listData_obj.totalpage = xmlData.photos.@pages;
			listData_obj.perpage = xmlData.photos.@perpage;
			listData_obj.total = xmlData.photos.@total;
			
			/*
			_s	small square 75x75
			_t	thumbnail, 100 on longest side
			_m	small, 240 on longest side
			""	medium, 500 on longest side
			_b	large, 1024 on longest side (only exists for very large original images)
			_o	original image, either a jpg, gif or png, depending on source format
			*/
			
			
			for(var i:int=0;i<length;i++){
				var farm:String = xmlList[i].@farm;
				var server:String = xmlList[i].@server;
				var id:String = xmlList[i].@id;
				var secret:String = xmlList[i].@secret;
				var title:String = xmlList[i].@title;
				var userID:String = xmlList[i].@owner;
				
				var obj:Object = new Object();
				
				for (var a:String in photoSize_obj) {
					var url:String = "http://farm" + farm + ".static.flickr.com/" + server + "/" + id + "_" + secret + photoSize_obj[a] +".jpg";
					obj[a] = url;
				}
				
				obj.title = title;
				obj.userID = userID;
				
				imageUrl_arr.push(obj);
			}
			
			sendUrlCompleteEvent();
		}
		
		/**
		 * ユーザー検索
		 * @param	__str		ユーザーID
		 */
		public function searchUsers(__str:String):void{
			//Xmlのロード
			var url:String = "http://api.flickr.com/services/rest/?method=flickr.people.getInfo&api_key="+APIkey+"&user_id=" + __str;
			
			var request:URLRequest = new URLRequest(url);
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE,userXMLLoadComplete);
			loader.load(request);
		}
		
		/**
		 * 検索終了後
		 * @param	__ev		イベント
		 */
		private function userXMLLoadComplete(__ev:Event):void{
			var loader:URLLoader = URLLoader(__ev.target);
			var xmlData = XML(loader.data);
			var id:String = xmlData.person.@id;
			var userName:String = xmlData.person.username;
			var length:uint = imageUrl_arr.length;
			maxCount = length;
			
			for (var i:uint = 0; i < length; i++) {
				if (imageUrl_arr[i].userID == id) {
					imageUrl_arr[i].userName = userName;
					sendUserCompleteEvent();
					break;
				}
			}
		}
		
		
		/**
		 * イベント発信
		 */
		private function sendUrlCompleteEvent():void{
			//イベント発信
			var ev:Event = new Event(URL_SET_COMPLETE);
			this.dispatchEvent(ev);
		}
		
		/**
		 * イベント発信
		 */
		private function sendUserCompleteEvent():void{
			//イベント発信
			var ev:Event = new Event(USER_SET_COMPLETE);
			this.dispatchEvent(ev);
		}
		
		
		//getter setter////////////////////////////////////////
		
		/**
		 * 画像データ
		 */
		public function get _data():Array{
			return imageUrl_arr;
		}
		
		/**
		 * 検索結果情報
		 */
		public function get _listData():Object{
			return listData_obj;
		}
		
		/**
		 * 表示ページ指定
		 */
		public function set _startPage(__uint:uint):void{
			startPage = __uint;
		}
		
		/**
		 * 表示枚数指定
		 */
		public function set _pageValue(__uint:uint):void{
			pageValue = __uint;
		}
	}
}