﻿/*
●AllArea
*/

package{
	import flash.display.MovieClip;
	import flash.display.Stage;
	import flash.display.StageAlign;
	import flash.display.Bitmap;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.display.Loader;
	import flash.system.LoaderContext;
	import util.FlickrConnect;
	
	public class AllArea extends MovieClip{
		
		/**
		 * property*******************************************************************************
		 */
		private var flickr:FlickrConnect;
		private var pos_x:int;
		private var pos_y:int;
		private var load_arr:Array;
		
		
		/**
		 * constructor**************************************************************************
		 */
		public function AllArea(){
			init();
		}
		
		/**
		 * function*****************************************************************************
		 */
		
		private function init(){
			var stage:Stage = this.stage;
			stage.scaleMode = "noScale";
			stage.align = StageAlign.TOP_LEFT;
			
			load_arr = new Array();
			
			setFlickrConnect();
			setBtn();
		}
		
		//Connect準備
		private function setFlickrConnect(){
			var APIkey:String = "あなたのAPIkey";
			flickr = new FlickrConnect(APIkey);
			flickr._pageValue = 80;//表示件数
			flickr.addEventListener(FlickrConnect.URL_SET_COMPLETE, setImageUrl);
		}
		
		//ボタンセット
		private function setBtn(){
			this.btn_btn.addEventListener(MouseEvent.CLICK, btnSearchClick);
			this.prev_btn.addEventListener(MouseEvent.CLICK, btnPrevClick);
			this.next_btn.addEventListener(MouseEvent.CLICK, btnNextClick);
		}
		
		//サーチボタンクリック時
		private function btnSearchClick(ev:MouseEvent) {
			flickr._startPage = 1;//開始ページ
			search();
		}
		
		//検索実行
		private function search() {
			//画像消去
			while(this.load_mc.numChildren > 1){
				this.load_mc.removeChildAt(this.load_mc.numChildren-1);
			}
			this.hit_txt.text = "";
			this.page_txt.text = "";
			
			flickr.search(this.search_txt.text);//検索実行
		}
		
		//前頁へ
		private function btnPrevClick(__ev:MouseEvent) {
			var page:uint = flickr._listData.page;
			if (page > 1) {
				flickr._startPage = page - 1;
				search();
			}
		}
		
		//次頁へ
		private function btnNextClick(__ev:MouseEvent) {
			var page:uint = flickr._listData.page;
			var totalpage:uint = flickr._listData.totalpage;
			if (page < totalpage) {
				flickr._startPage = page + 1;
				search();
			}
		}
		
		//検索終了後
		private function setImageUrl(ev:Event){
			pos_x = 0;
			pos_y = 0;
			
			var _arr:Array = flickr._data;
			var _length:int = _arr.length;
			this.hit_txt.text = flickr._listData.total;
			this.page_txt.text = flickr._listData.page+"/"+flickr._listData.totalpage;//現在のページ/総ページ
			
			for(var i:uint=0;i<_length;i++){
				setLoadImage(_arr[i].square);
				//trace(_arr[i].title);
			}
		}
		
		//画像のロード
		private function setLoadImage(__url:String){
			var request:URLRequest = new URLRequest(__url);
			var loader:Loader = new Loader();
			
			loader.contentLoaderInfo.addEventListener(Event.INIT,loadImageInit);
			loader.load(request, new LoaderContext(true));
		}
		
		//ロード終了後
		private function loadImageInit(ev:Event){
			var bitmap:Bitmap = ev.target.content;
			
			bitmap.x = pos_x;
			bitmap.y = pos_y;
			
			pos_x += bitmap.width;
			
			if(pos_x >= this.stage.stageWidth){
				pos_y += bitmap.height;
				pos_x = 0;
			}
			
			this.load_mc.addChild(bitmap);
		}
	}
}