﻿//****************************************************************************
//Spiral3Dクラス
//@auther Masayuki Daijima
//****************************************************************************

package {
	import flash.display.*;
	import flash.events.*;
	
	//papervision3Dクラスをインポート
	import org.papervision3d.scenes.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.*;
	
	public class Spiral3D extends Sprite {
		// _______________________________________________________________________
		// メンバ定義
		private var container					: Sprite;
		private var scene 						: Scene3D;
		private var camera						: Camera3D;
		
		private var material					: BitmapFileMaterial;
		
        private var rootNode					: DisplayObject3D;
		
		private var objHolder					: Array;
		private var objLength					: int = 100;
		
		private var valX 						: Number = 0;
		private var valY						: Number = 0;
		
		// _______________________________________________________________________
		// コンストラクタ
		public function Spiral3D():void {
			//ステージ設定
			stage.frameRate = 60;
			stage.quality = "BEST";
			stage.scaleMode = "noScale";
			stage.align = StageAlign.TOP_LEFT;
			
			initialize3D();
		}
		
		// _______________________________________________________________________
		// 3D空間の初期設定
		private function initialize3D():void {
			var i:int;
			
			//3D空間のベースとなるコンテナ生成
			container = new Sprite();
			addChild(this.container);
			container.x = this.stage.stageWidth / 2;
			container.y = this.stage.stageHeight / 2;
			
			//3Dシーン生成
			scene = new Scene3D( container );
			
			//カメラ設定
			camera = new Camera3D();
			camera.z = -1500;
			camera.focus = 500;
			camera.zoom = 1;
			
			//rootNode生成
            rootNode = new DisplayObject3D();
            scene.addChild(rootNode);
			
			//マテリアル設定
			material = new BitmapFileMaterial( "images/sample.gif" );
			material.doubleSided = true;
			
			//DisplayObject3Dを格納する配列
			objHolder = [];
			
			//Planeオブジェクト生成
			for (i = 0; i <= objLength; i++) {
				createPlaneObject();
			}
			
			//Planeオブジェクトを螺旋状に配置
            var obj:DisplayObject3D;
            var sp:Number = 700;
			var deg:Number = 10;
            var pos:Number;
			
			for (i = 0; i <= objHolder.length-1; i++) {
				obj = objHolder[i];
                pos = Math.sin(i * deg * (Math.PI / 180));
                obj.x = sp * pos;
                obj.y = -7000 + i * 300;
                obj.z = sp * pos;
                obj.rotationY = i * deg;
                rootNode.addChild(obj);
			}
			
			addEvents();
		}
		
		private function createPlaneObject():void {
			var planeObj = new Plane( material, 250, 250, 4, 4);
			objHolder.push(planeObj);
		}
		
		// _______________________________________________________________________
		// イベント設定
		private function addEvents():void {
			this.addEventListener(Event.ENTER_FRAME, update3D);
			this.stage.addEventListener(Event.RESIZE, onStageResize);
		}
		
		// _______________________________________________________________________
		// ENTER_FRAMEイベント処理
		private function update3D( event:Event ):void {
			//マウス座標でオブジェクトを回転
			valX += container.mouseY / 100;
			valY += container.mouseX / 100;
			
			rootNode.rotationX = valX;
			rootNode.rotationY = valY;

			//3Dシーンをレンダリング
			scene.renderCamera( camera );
		}
		
		// _______________________________________________________________________
		// ステージリサイズイベント処理
		private function onStageResize( event:Event ):void {
			container.x = this.stage.stageWidth / 2;
			container.y = this.stage.stageHeight / 2;
		}
	}
}