﻿//****************************************************************************
//Circle3Dクラス
//@auther Masayuki Daijima
//****************************************************************************

package {
	import flash.display.*;
	import flash.events.*;
	
	//papervision3Dクラスをインポート
	import org.papervision3d.scenes.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.*;
	
	public class Circle3D extends Sprite {
		// _______________________________________________________________________
		// メンバ定義
		private var container						: Sprite;
		private var scene 							: Scene3D;
		private var camera							: Camera3D;
		
		private var material							: BitmapFileMaterial;
		private var material2						: BitmapFileMaterial;
		private var material3						: BitmapFileMaterial;
		
        private var rootNode						: DisplayObject3D;
			
		private var objHolder						: Array;
		private var objLength						: int = 10;
		
		private var valX 								: Number = 0;
		private var valY								: Number = 0;
		
		// _______________________________________________________________________
		// コンストラクタ
		public function Circle3D():void {
			//ステージ設定
			stage.frameRate = 60;
			stage.quality = "BEST";
			stage.scaleMode = "noScale";
			stage.align = StageAlign.TOP_LEFT;
			
			initialize3D();
		}
		
		// _______________________________________________________________________
		// 3D空間の初期設定
		private function initialize3D():void {
			var i:int;
			
			//3D空間のベースとなるコンテナ生成
			container = new Sprite();
			addChild(this.container);
			container.x = this.stage.stageWidth / 2;
			container.y = this.stage.stageHeight / 2;
			
			//3Dシーン生成
			scene = new Scene3D( container );
			
			//カメラ設定
			camera = new Camera3D();
			camera.z = -1000;
			camera.focus = 500;
			camera.zoom = 1;
			
			//rootNode生成
            rootNode = new DisplayObject3D();
            scene.addChild(rootNode);
			
			//マテリアル設定
			material = new BitmapFileMaterial( "images/sample.gif" );
			material.doubleSided = true;
			material2 = new BitmapFileMaterial( "images/sample2.gif" );
			material3 = new BitmapFileMaterial( "images/sample3.gif" );
			
			//DisplayObject3Dを格納する配列
			objHolder = [];
			
			for (i = 0; i <= objLength; i++) {
				//1～5までのランダム値を生成
				var rand = Math.floor(Math.random() * 5 + 1);
				//生成したランダム値をパラメータで渡す
				randomCreateDiplayObject3D(rand);
			}
			
            var posX:Number = 0;
            var posY:Number = 0;
            var posZ:Number = 0;
            var obj:DisplayObject3D;
            var deg:Number = 360 / objHolder.length;
            var ndeg:Number = 0;
			var radius:int = 800;
			
			for (i = 0; i <= objHolder.length-1; i++) {
                ndeg = ndeg + deg;
				obj = objHolder[i];
                posX = Math.cos(ndeg * Math.PI / 180) * radius;
                posZ = Math.sin(ndeg * Math.PI / 180) * radius;
                rootNode.addChild(obj);
                obj.x = posX;
                obj.y = posY;
                obj.z = posZ;
                obj.lookAt(rootNode);
			}
			
			addEvents();
		}
		
		//ランダムに数パターンのDiplayObject3Dを生成
		private function randomCreateDiplayObject3D(randInt:int):void {
			switch(randInt) {
				case 1:
					//Planeオブジェクト生成
					var planeObj = new Plane( material, 250, 250, 4, 4 );
					objHolder.push(planeObj);
					break;
				case 2:
					//Cubeオブジェクト生成
					var cubeObj = new OldCube( material, 200, 200, 200, 2, 2 );
					objHolder.push(cubeObj);
					break;
				case 3:
					//Cylinderオブジェクト生成
					var cylinderObj = new Cylinder( material2, 80, 300, 16, 16 );
					objHolder.push(cylinderObj);
					break;
					
				case 4:	
					//PaperPlaneオブジェクト生成
					var paperPlaneObj = new PaperPlane( material, 1.7 );
					objHolder.push(paperPlaneObj);
					break;
					
				case 5:
					//Sphereオブジェクト生成
					var sphereObj = new Sphere( material3, 100, 16, 12 );
					objHolder.push(sphereObj);
					break;
			}
		}
		
		// _______________________________________________________________________
		// イベント設定
		private function addEvents():void {
			this.addEventListener(Event.ENTER_FRAME, update3D);
			this.stage.addEventListener(Event.RESIZE, onStageResize);
		}
		
		// _______________________________________________________________________
		// ENTER_FRAMEイベント処理
		private function update3D( event:Event ):void {
			//マウス座標でオブジェクトを回転
			valX += container.mouseY / 100;
			valY += container.mouseX / 100;
			
			rootNode.rotationX = valX;
			rootNode.rotationY = valY;
			
			//3Dシーンをレンダリング
			scene.renderCamera( camera );
		}
		
		// _______________________________________________________________________
		// ステージリサイズイベント処理
		private function onStageResize( event:Event ):void {
			container.x = this.stage.stageWidth / 2;
			container.y = this.stage.stageHeight / 2;
		}
	}
}