﻿package {

	//Flashクラスをインポート
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;

	//Box2Dクラスをインポート
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;

	public class sample2 extends Sprite {

		public var m_world:b2World;
		public var m_iterations:int = 10;
		public var m_timeStep:Number = 1.0/30.0;
		public var m_physScale:int = 30;

		public function sample2() {

			// 衝突判定の設定
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100.0, -100.0);
			worldAABB.upperBound.Set(100.0, 100.0);

			// 重力の設定
			var gravity:b2Vec2 = new b2Vec2(0,20);

			// 外部から影響がないオブジェクトはBox2Dの物理計算のリストから自動的に除外、通常はtrue
			var doSleep:Boolean = true;

			//ワールドオブジェクトの生成
			m_world = new b2World(worldAABB, gravity, doSleep);

			//床の生成
			var body:b2Body;
			var bodyDef:b2BodyDef;
			var boxDef:b2PolygonDef;
			
			//Bodyを作成
			bodyDef = new b2BodyDef();
			bodyDef.position.Set(10, 12);
			bodyDef.userData = new PhysGround();//ライブラリより生成
			bodyDef.userData.width = 30 * 2 * m_physScale;//30はSetAsBox(30, 3)の30
			bodyDef.userData.height = 3 * 2 * m_physScale;//3はSetAsBox(30, 3)の3
			
			//Shapeを作成
			boxDef = new b2PolygonDef();			
			boxDef.SetAsBox(30, 3);
			boxDef.friction = 0.3;
			
			//WorldにBodyを実体化
			body = m_world.CreateStaticBody(bodyDef);			
			body.CreateShape(boxDef);
			body.SetMassFromShapes();		
			addChild(bodyDef.userData);
			//床の生成終了

			// オブジェクトを10個ワールドに追加
			for (var i:int = 1; i < 10; i++) {
				addSomeObject(Math.random() * 15 + 3,Math.random() * 10 - 3);
			}
			
			//物理エンジンを回すイベントを登録
			addEventListener(Event.ENTER_FRAME, Update);
			
			//マウスクリックイベントを登録
			stage.addEventListener(MouseEvent.CLICK, addSomeObjectByClick);
		}
		
		/*クリックでオブジェクトをワールドに追加するメソッド*/
		public function addSomeObjectByClick(e:Event):void {
			addSomeObject(stage.mouseX/m_physScale,stage.mouseY/m_physScale);
		}
		
		/*オブジェクトをワールドに追加するメソッド*/
		public function addSomeObject(posx,posy):void {

			var body:b2Body;
			var bodyDef:b2BodyDef;
			var boxDef:b2PolygonDef;
			var circleDef:b2CircleDef;
			var rX:Number;
			var rY:Number;			
			
			//Bodyを作成
			bodyDef = new b2BodyDef();
			bodyDef.position.Set(posx, posy);
			rX = Math.random() + 0.5;
			rY = Math.random() + 0.5;
			bodyDef.userData = new PhysBox();//ライブラリより生成
			bodyDef.userData.transform.colorTransform = getRandomColor();
			bodyDef.userData.width = rX * 2 * m_physScale;
			bodyDef.userData.height = rY * 2 * m_physScale;

			//箱
			if (Math.random() < 0.5){
				boxDef = new b2PolygonDef();
				boxDef.SetAsBox(rX, rY);
				boxDef.density = 2.0;//密度設定
				boxDef.friction = 0.5;//摩擦力設定
				boxDef.restitution = 0.5;//跳ね返り係数設定(0以上の値を設定。何倍の力で跳ね返るのか設定する。)
				bodyDef.userData = new PhysBox();//ライブラリより生成
				bodyDef.userData.transform.colorTransform = getRandomColor();
				bodyDef.userData.width = rX * 2 * m_physScale;
				bodyDef.userData.height = rY * 2 * m_physScale;
				body = m_world.CreateDynamicBody(bodyDef);
				body.CreateShape(boxDef);
			//円
			} else {
				circleDef = new b2CircleDef();
				circleDef.radius = rX;
				circleDef.density = 2.0;//密度設定
				circleDef.friction = 0.5;//摩擦力設定
				circleDef.restitution = 0.5;//跳ね返り係数設定(0以上の値を設定。何倍の力で跳ね返るのか設定する。)
				bodyDef.userData = new PhysCircle();//ライブラリより生成
				bodyDef.userData.transform.colorTransform = getRandomColor();
				bodyDef.userData.width = rX * 2 * m_physScale;
				bodyDef.userData.height = rX * 2 * m_physScale; 
				body = m_world.CreateDynamicBody(bodyDef);
				body.CreateShape(circleDef);				
			}						
			body.SetMassFromShapes();
			addChild(bodyDef.userData);
		}
		
		//物理エンジンを回すメソッド
		public function Update(e:Event):void {
			m_world.Step(m_timeStep, m_iterations);
			for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next) {
				if (bb.m_userData is Sprite) {
					bb.m_userData.x = bb.GetPosition().x * m_physScale;
					bb.m_userData.y = bb.GetPosition().y * m_physScale;
					bb.m_userData.rotation = bb.GetAngle() * (180/Math.PI);
				}
			}
		}
		
		//ランダムなカラーが付与された ColorTransform オブジェクトを生成
		function getRandomColor():ColorTransform {
			var red:Number = (Math.random() * 512) - 255;
			var green:Number = (Math.random() * 512) - 255;
			var blue:Number = (Math.random() * 512) - 255;
			return new ColorTransform(1,1,1,1,red,green,blue,0);
		}
	}

}