<?php
class Link {
  public $next;
  public $key;
  public $value;

  public function __construct( $key, $value )
  {
    $this->next  = null;
    $this->key   = $key;
    $this->value = $value;
  }
}

function insert( &$anchor, $key, $value )
{
  $obj = new Link( $key, $value );
  $obj->next = $anchor;
  $anchor = $obj;
}

function search( $anchor, $key )
{
  for( $obj = $anchor ; $obj != null ; $obj = $obj->next ) {
    if( $obj->key == $key ) {
      return $obj->value;
    }
  }
  return null; 
}

function delete( &$anchor, $key )
{
  for( $prev = &$anchor ; $prev != null ; $prev = &$prev->next ) {
    if( $prev->key == $key ) {
      $obj = $prev;
      $prev = $obj->next;
      $obj->next = null;
      return $obj;
    }
  }
  return null; 
}

function printLink( $anchor )
{
  if( $anchor==null ) {
    print "\n";
  } else {
    print "($anchor->key,$anchor->value)";
    printLink( $anchor->next );
  }
}
?>
