<?php
$VERSION ="alpha";
$startTime = microtime(true);
$InputFile = "";
$splitN = 10000;
$FilePrefix = "xml2freddy";
$Sep = "_";
$Ext = ".js";
$ExtIdx = ".idx";
$Path = "";
$Url  = "";
$Dir  = "";
$PhpFE = "index.php";
$freddyLib = "http://freddy.yokoyama.ac/lib/freddy-it.js";
$MaxPage=10;
$STDIN = false;
$NOCOMP  = false;
$VOLUME   = false;
$OVERWRITE = false;
$STRICT = false;
$FLAT = false;
$EXAMPLE = false;
$HOLDINGS = false;
$FRONTEND = false;
$QUIET = false;
$BENCHMARK = false;

$eventN=0;
$ele=Array();
$fileExample = "example.html";
$fileBench = "benchmark.html";
function getPathSaveFile($next = false){
	global $Path,$Dir,$FilePrefix,$Sep,$Ext,$VOLUME;
	if(!$VOLUME){
		if($next){
			return $Path.$Dir.$FilePrefix.$Sep.getNextPageNum().$Ext;
		}else{
			return $Path.$Dir.$FilePrefix.$Sep.getCurrentPageNum().$Ext;
		}
	}else{
		if($next){
			return $Path.$Dir.$FilePrefix.$Sep.getVolumu(getNextPageNum()).$Ext;
		}else{
			return $Path.$Dir.$FilePrefix.$Sep.getVolumu(getCurrentPageNum()).$Ext;
		}
	}
}

function getPathIdxFile(){
	global $Path,$Dir,$FilePrefix,$Sep,$ExtIdx;
	return $Path.$Dir.$FilePrefix.$Sep.getVolumu(getCurrentPageNum()).$ExtIdx;
}

function getVolumu($page,$vol=0){
	global $MaxPage,$FLAT;
	if($FLAT){
		return floor($page / $MaxPage);
	}else{
		if($page <= $vol){
			return $vol;
		}else{
			if(($vol+1) >= $MaxPage){
				return floor($vol + ($page/$MaxPage));
			}else{
				return getVolumu($page - $vol - 1,$vol + 1);
			}
		}
	}
}


function getUrlNextFile(){
	global $Url,$Dir,$FilePrefix,$Sep,$Ext;
	return $Url.$Dir.$FilePrefix.$Sep.getNextPageNum().$Ext;
}
function getCurrentPageNum(){
	global $eventN,$splitN;
	return (($eventN-($eventN%$splitN))/$splitN);
}
function getNextPageNum(){
	global $eventN,$splitN;
	return 1+(($eventN-($eventN%$splitN))/$splitN);
}
function escape($str){
	return str_replace("\t","\\t",str_replace("\r","\\r",str_replace("\n",'\\n',str_replace("'","\\'",str_replace("\\","\\\\",$str)))));
}

if(count($argv)==1){
	echo "
This is xml2freddy.php, the XML to FREDDY converter.
Version:  $VERSION

Usage:
   wget -q --tries=1 -O http://foo/bar.xml | php xml2freddy.php [OPTIONS]
   php xml2freddy.php -I bar.xml [OPTIONS]

General flags:
  -STDIN               STDINからXMLファイルを入力する
  -OVERWRITE           OUTPUTファイルを上書きする。ディレクトリを作り直す
  -NOCOMP              圧縮しないで保存する
  -VOLUME              ページをボリュームファイルでまとめる
  -FRONTEND            PHPフロントエンドを作成する
  -STRICT              文字列前後のホワイトスペース・改行等をキープする
  -HOLDINGS            FREDDYホールディングスファイルを作る
  -QUIET               エラー以外の出力(STDOUT)をしない
  -EXAMPLE             FREDDYのサンプルアプリを生成する
  -BENCHMARK           読み込み速度計測の為のシンプルアプリを生成する
                     
General options:     
  -I InputFile         FREDDYに変換する為の入力XMLファイル
  -L LibraryURL        FREDDYライブラリのURL [default: ".$freddyLib."]
  -N NumEvents         1 pageあたりのイベント数 [default: ".$splitN."]
  -P PathInputDir      出力ファイルの格納ディレクトリ
  -F FilePrefix        出力ファイル名のプレフィクス [default: ".$FilePrefix."]
  -S Separator         プレフィクス・番号間のセパレータ [default: ".$Sep."]
  -E Extension         出力ファイルの拡張子 [default: ".$Ext."]
  -U BaseURL           PathInputDirに対応する出力ファイルのペースURL
  -D Dir               PathInputDirに新しいディレクトリDirを作成する
                       
VOLUME options:        
  -M MaxPage           １ボリューム内の最大ページ数 [default: ".$MaxPage."]
  -X ExtensionOfIndex  ボリュームインデクスファイルの拡張子[default. ".$ExtIdx."]
  -FLAT                全てのボリューム内のページ数をMax Pageとする
  
FRONTEND option
  -H PhpFile           PHPフロントエンド ファイル名 [default: ".$PhpFE."]
  
";
	exit(0);
}else{
	$mode = "";
	foreach ($argv as $a) {
		if(0 === strpos($a,"-")){
			switch($a){
				case "-STDIN":
					$STDIN = true;
					$InputFile = "php://stdin";
					$mode = "";
					break;
				case "-NOCOMP":
					$NOCOMP = true;
					$mode = "";
					break;
				case "-VOLUME":
					$VOLUME = true;
					$mode = "";
					break;
				case "-OVERWRITE":
					$OVERWRITE = true;
					$mode = "";
					break;
				case "-STRICT":
					$STRICT = true;
					$mode = "";
					break;
				case "-FLAT":
					$FLAT = true;
					$mode = "";
					break;
				case "-EXAMPLE":
					$EXAMPLE = true;
					$mode = "";
					break;
				case "-HOLDINGS":
					$HOLDINGS = true;
					$mode = "";
					break;
				case "-FRONTEND":
					$FRONTEND = true;
					$mode = "";
					break;
				case "-QUIET":
					$QUIET = true;
					$mode = "";
					break;
				case "-BENCHMARK":
					$BENCHMARK = true;
					$mode = "";
					break;
				default:
					$mode = $a;
			}
		}else{
			switch($mode){
				case "-I":
					$InputFile = $a;
					break;
				case "-L":
					$freddyLib = $a;
					break;
				case "-N":
					$splitN = $a;
					break;
				case "-F":
					$FilePrefix = $a;
					break;
				case "-P":
					$Path = $a;
					if(strrpos($Path,"/")!==strlen($Path)-1){
						$Path .= "/";
					}
					break;
				case "-E":
					$Ext = $a;
					if(strpos($Ext,".")!==0){
						$Ext .= ".".$Ext;
					}
					break;
				case "-X":
					$ExtIdx = $a;
					if(strpos($ExtIdx,".")!==0){
						$ExtIdx .= ".".$ExtIdx;
					}
					break;
				case "-U":
					$Url = escape($a);
					if(strrpos($Url,"/")!==strlen($Url)-1){
						$Url .= "/";
					}
					break;
				case "-D":
					$Dir = escape($a);
					if(strrpos($Dir,"/")!==strlen($Dir)-1){
						$Dir .= "/";
					}
					break;
				case "-S":
					$Sep = $a;
					break;
				case "-H":
					$PhpFE = $a;
					break;
				case "-M":
					$MaxPage = $a;
					break;
			}
			$mode = "";
		}
	}
}

//-- 引数検査
if($STDIN == false and $InputFile == ""){
	echo "[ERROR]  入力ファイルを指定してください。\n\n";
	exit(0);
}
if($Path == ""){
	echo "[ERROR]  出力ファイルのパスが指定されていません。\n\n";
	exit(0);
}
if(!$VOLUME and $Url == ""){
	echo "[ERROR] 出力ファイルのペースURLが指定されていません。\n\n";
	exit(0);
}

//--最初の出力ファイル作成
$currentFile = "";
$currentPage = getCurrentPageNum();
switchNewFile();

$tagList = Array();
function comp($name){
	global $tagList;
	if(!isset($tagList[$name])){
		$tagList[$name] = tagEncode(count($tagList));
		return $name;
	
	}else{
		return $tagList[$name];
	}
}
$ascii = Array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q",
               "r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H",
               "I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y",
               "Z","0","1","2","3","4","5","6","7","8","9");
function tagEncode($index){
	global $ascii;
	if(count($ascii) <= $index){
		return tagEncode(floor($index / count($ascii))-1) . $ascii[$index % count($ascii)];
	}else{
		return $ascii[$index];
	}
}

function switchNewFile($final = false){
	global $out,$idx,$currentFile,$currentPage,$VOLUME,$Url,$Path,$Dir,$Ext,$OVERWRITE;
	$start = false;
	if(isset($out)){
		if($currentFile != getPathSaveFile()){
			if($VOLUME and isset($idx)){
				fwrite($idx,getCurrentPageNum().",".ftell($out)."\n");
				fclose($idx);
			}
			fclose($out);
		}
	}else{
		if($Dir != ""){
			if(is_dir($Path.$Dir)){
				if($OVERWRITE){
					$handle = opendir($Path.$Dir);
					for (;false !== ($file = readdir($handle));) if($file != "." && $file != "..") unlink($Path.$Dir.$file);
					closedir($handle);
					rmdir($Path.$Dir);
				}else{
					echo "[ERROR]   ディレクトリが既に存在します。上書きするには-OVERWRITEオプションを付けてください。";
					exit(0);
				}
			}elseif(is_file($Path.$Dir) or  is_link($Path.$Dir)){
				echo "[ERROR]   ディレクトリ作成エラー。ファイルまたはシンボリックリンクとして既に使われています。";
			}
			mkdir($Path.$Dir,0755);
		}
		$start = true;
	}
	if($final){
		if($currentFile != getPathSaveFile()){
			$currentFile = getPathSaveFile(true);
			$out = fopen($currentFile, "w");
			if($VOLUME){
				$idx = fopen(getPathIdxFile(),"w");
			}
		}
		if($VOLUME){
			fwrite($idx,getNextPageNum().",".ftell($out)."\n");
		}
		fwrite($out,"ed();");
		if($VOLUME){
			fwrite($idx,getNextPageNum().",".ftell($out)."\n");
		}
	}else{
		if($currentFile != getPathSaveFile()){
			$currentFile = getPathSaveFile();
			$out = fopen($currentFile, "w");
			if($VOLUME){
				$idx = fopen(getPathIdxFile(),"w");
			}
		}
		if($VOLUME){
			fwrite($idx,getCurrentPageNum().",".ftell($out)."\n");
		}
		fwrite($out,"np(".getNextPageNum());
		if(!$VOLUME){
			fwrite($out,",'".getUrlNextFile()."'");
		}
		fwrite($out,");");
		if($start){
			$start = false;
			fwrite($out,"sd();");
		}
		$currentPage = getCurrentPageNum();
	}
}

function finalize(){
	global $out,$HOLDINGS,$FRONTEND,$VOLUME,$BENCHMARK,$EXAMPLE,$FLAT,$Path,$Url,$Dir,$FilePrefix,$Sep,$Ext,$ExtIdx,$eventN,$PhpFE,$MaxPage,$freddyLib,$fileExample,$fileBench;
	switchNewFile(true);
	fclose($out);
	//fclose($idx);
	if($HOLDINGS){
		$hld = fopen($Path.$Dir.$FilePrefix.$Ext,"w");
		fwrite($hld,"header({\n");
		fwrite($hld,"\t'CREATE'  : new Date(\"".date("o/n/j H:i:s")."\"),\n");
		fwrite($hld,"\t'NUMEVENT':'".$eventN."',\n");
		fwrite($hld,"\t'GENERATOR':{\n");
		fwrite($hld,"\t\t'NAME'     :'XML2FREDDY.php',\n");
		fwrite($hld,"\t\t'VERSION'  :'alpha'\n");
		fwrite($hld,"\t},\n");
		fwrite($hld,"\t'OPTION'  :{\n");
		fwrite($hld,"\t\t'-BENCHMARK': ".stringTrueFalse($GLOBALS["BENCHMARK"]).",\n");
		fwrite($hld,"\t\t'-EXAMPLE'  : ".stringTrueFalse($GLOBALS["EXAMPLE"]).",\n");
		fwrite($hld,"\t\t'-FRONTEND' : ".stringTrueFalse($GLOBALS["FRONTEND"]).",\n");
		if($GLOBALS["FRONTEND"]){
			fwrite($hld,"\t\t  '-H'        :'".escape($GLOBALS["PhpFE"])."',\n");
		}
		fwrite($hld,"\t\t'-HOLDINGS' : ".stringTrueFalse($GLOBALS["HOLDINGS"]).",\n");
		fwrite($hld,"\t\t'-NOCOMP'   : ".stringTrueFalse($GLOBALS["NOCOMP"]).",\n");
		fwrite($hld,"\t\t'-STRICT'   : ".stringTrueFalse($GLOBALS["STRICT"]).",\n");
		fwrite($hld,"\t\t'-VOLUME'   : ".stringTrueFalse($GLOBALS["VOLUME"]).",\n");
		if($GLOBALS["VOLUME"]){
			fwrite($hld,"\t\t  '-FLAT'    : ".stringTrueFalse($GLOBALS["FLAT"]).",\n");
			fwrite($hld,"\t\t  '-M'       :'".escape($GLOBALS["MaxPage"])."',\n");
			fwrite($hld,"\t\t  '-X'       :'".escape($GLOBALS["ExtIdx"])."',\n");
		}
		fwrite($hld,"\t\t'-D'        :'".escape($GLOBALS["Dir"])."',\n");
		fwrite($hld,"\t\t'-E'        :'".escape($GLOBALS["Ext"])."',\n");
		fwrite($hld,"\t\t'-S'        :'".escape($GLOBALS["Sep"])."',\n");
		fwrite($hld,"\t\t'-N'        :'".escape($GLOBALS["splitN"])."',\n");
		fwrite($hld,"\t\t'-U'        :'".escape($GLOBALS["Url"])."'\n");
		fwrite($hld,"\t}\n");
		fwrite($hld,"});");
		fwrite($hld,"np(0");
		if(!$VOLUME){
			fwrite($hld,",'".$Url.$Dir.$FilePrefix.$Sep.'0'.$Ext."'");
		}
		fwrite($hld,");");
		fclose($hld);
	}
	if($FRONTEND){
		$firstPage = $Url.$Dir.$PhpFE;
	}elseif($HOLDINGS){
		$firstPage = $Url.$Dir.$FilePrefix.$Ext;
	}else{
		$firstPage = $Url.$Dir.$FilePrefix.$Sep.'0'.$Ext;
	}
	if($BENCHMARK){
		$benchmark = <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Freddy: Benchmark</title>
<script src="$freddyLib" type="text/javascript"> </script>
<script type="text/javascript">
function start(){
	var freddy = new Freddy.Parser.FreddyParser();
	var handler = new Freddy.Handler.CountEventHandler()
	handler.setFinishListener(this,function(){
		alert("Finish!\\n"+
		"  Count: "+ handler.count+" events\\n"+
		"  Time : "+ ((handler.endTime - handler.startTime)/1000) + " sec.");
	});
	freddy.setHandler(handler);
	freddy.parse("$firstPage");
}
</script>
</head>
<body onload="start();">
Simple Benchmark of FREDDY
</body>
</html>
EOF;
		$fp = fopen($Path.$Dir.$fileBench,"w");
		fwrite($fp,$benchmark);
		fclose($fp);
	}
	if($EXAMPLE){
		$example = <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<title>Freddy Example Apprication</title>
		<style TYPE="text/css">
.TD0 { width: 150px;}
.TD1 { width: 60px;text-align:right; }
.TD2 { width: 100px;}
.TD3 { width: 150px;text-align:right; }
.TITLE {background-color:black; color:white;}
.EVEN {background-color:#e6e6fa;}
.ODD  {background-color:#eef3e2;}
#table {width:200px;height:400px;overflow:scroll;float:left;}
.graph0 {padding:10px;width:350px;height:380px;overflow:hidden;float:left;}
.graph1 {padding:10px;width:250px;height:380px;overflow:hidden;float:left;}
#result {width:250px;height:300px;overflow:hidden;}
		</style>
		<script src="$freddyLib" type="text/javascript"> </script>
		<script type="text/javascript">
URL = "$firstPage";

FreddyExampleHandler = function(){
	this.count["all"]=0;
	this.count["startElement"]=0;
	this.count["endElement"]=0;
	this.count["characters"]=0;
	this.count["attribute"] = 0;
};
FreddyExampleHandler.prototype = {
	//----- Handler
	startDocument:function(){
		this.startTime = (new Date()).getTime();
		if(this.documentOption != null){
			this.progMax = this.documentOption["NUMEVENT"];
		}
		var tbl = document.createElement("table");
		this.table = document.createElement("tbody");
		var tr = document.createElement("tr");
		var td0 = document.createElement("td");
		var td1 = document.createElement("td");
		td0.innerHTML = "Element Name";
		td0.className = "TD0 TITLE";
		td1.innerHTML = "Count";
		td1.className = "TD1 TITLE";
		tr.appendChild(td0);
		tr.appendChild(td1);
		this.table.appendChild(tr);
		tbl.appendChild(this.table);
		document.getElementById("table").appendChild(tbl);
	},
	startElement:function(name,attrs){
		this.strLen += name.length;
		this.count["all"]++; this.count["startElement"]++;
		for(var attr in attrs){
			this.strLen += attr.length + attrs[attr].length;
			this.count["attribute"]++;
			var check = false;
			for(var a in this.numA){
				if(a == attr){
					check = true;
					this.numA[attr]++;
				}
			}
			if(!check){
				this.numA[attr] = 1;
			}
		}
		for(var e in this.num){
			if(e == name){
				if(this.num[e]<0){
					this.num[e]--;
				}else{
					this.num[e]++;
				}
				return;
			}
		}
		this.num[name] = -1;
	},
	endElement:function(name){
		this.strLen += name.length;
		this.count["all"]++; this.count["endElement"]++;
	},
	characters:function(str){
		this.strLen += str.length;
		this.count["all"]++; this.count["characters"]++;
		if(this.count["all"] >= this.trig){
			this.trig += this.intvl;
			this.drawTable();
		}
	},
	endDocument:function(){
		this.endTime = (new Date()).getTime();
		this.drawTable();
		document.getElementById("start").innerHTML = "[DONE!]";
		var tbl = "<br/><br/><table>"+
		'<tr><td class="TD2 TITLE">&nbsp;</td><td class="TD3 TITLE">&nbsp;</td></tr>'+
		'<tr><td class="TD2 ODD">ALL</td><td class="TD3 ODD">'+this.count["all"]+' events</td></tr>'+
		'<tr><td class="TD2 EVEN">+startElement</td><td class="TD3 EVEN">'+this.count["startElement"]+' events</td></tr>'+
		'<tr><td class="TD2 ODD">+- with</td><td class="TD3 ODD">'+this.count["attribute"]+' attrs</td></tr>'+
		'<tr><td class="TD2 EVEN">+characters</td><td class="TD3 EVEN">'+this.count["characters"]+' events</td></tr>'+
		'<tr><td class="TD2 ODD">+endElement</td><td class="TD3 ODD">'+this.count["endElement"]+' events</td></tr>'+
		'<tr><td class="TD2 TITLE">&nbsp;</td><td class="TD3 TITLE">&nbsp;</td></tr>'+
		'<tr><td class="TD2 EVEN">Length</td><td class="TD3 EVEN">'+this.strLen+' chars</td></tr>'+
		'<tr><td class="TD2 ODD">Time</td><td class="TD3 ODD">'+((this.endTime-this.startTime)/1000)+' sec.</td></tr>'+
		'<tr><td class="TD2 EVEN">Throughput</td><td class="TD3 EVEN">'+Math.round(this.strLen/((this.endTime-this.startTime)/1000))+' char./sec.</td></tr>'+
		'</table>';
		 document.getElementById("result").innerHTML = tbl;
	},
	//----- Method
	drawTable:function(){
		var arr = Array();
		var sum = 0;
		for(var e in this.num){
			arr.push({"name":e,"num":Math.abs(this.num[e])});
			sum += this.num[e];
			if(this.num[e]<0){
				this.num[e] = Math.abs(this.num[e]);
				var tr = document.createElement("tr");
				var td0 = document.createElement("td");
				var td1 = document.createElement("td");
				if(this.ODD){
					td0.className = "TD0 ODD";
					td1.className = "TD1 ODD";
					this.ODD = false;
				}else{
					td0.className = "TD0 EVEN";
					td1.className = "TD1 EVEN";
					this.ODD = true;
				}
				td0.innerHTML=e;
				td1.innerHTML=this.num[e];
				this.table.appendChild(tr);
				tr.appendChild(td0);
				tr.appendChild(td1);
				this.element[e] = td1;
				
			}else{
				this.element[e].innerHTML = this.num[e];
			}
		}
		arr.sort(function(x,y){return x["num"] > y["num"] ? -1 : 1; });
		var chl = Array();
		var chd = Array();
		var rest = 100;
		var rank = 0;
		for(var c in arr){
			var val = Math.round(100*arr[c]["num"]/sum);
			if(val >= 1 && ++rank < 25){
				chl.push(arr[c]["name"]);
				chd.push(val);
				rest -= Math.round(val);
			}
		}
		chl.push("Others");
		chd.push(rest);
		document.getElementById("imgEleCount").src = "http://chart.apis.google.com/chart?chco=ff4444,7777ff&chs=350x190&chd=t:"+chd.join(",")+"&cht=p&chl="+chl.join("|");
		arr = Array();
		sum = 0;
		for(var e in this.numA){
			arr.push({"name":e,"num":Math.abs(this.numA[e])});
			sum += this.numA[e];
		}
		arr.sort(function(x,y){return x["num"] > y["num"] ? -1 : 1; });
		chl = Array();
		chd = Array();
		rest = 100;
		rank = 0;
		for(var c in arr){
			var val = Math.round(100*arr[c]["num"]/sum);
			if(val >= 1 && ++rank < 25){
				chl.push("@"+arr[c]["name"]);
				chd.push(val);
				rest -= val;
			}
		}
		chl.push("Others");
		chd.push(rest);
		document.getElementById("imgAttrCount").src = "http://chart.apis.google.com/chart?chco=dddd33,66ff66&chs=350x190&chd=t:"+chd.join(",")+"&cht=p&chl="+chl.join("|");
		this.thput.push(this.strLen/(((new Date().getTime())-this.startTime)/1000));
		var max = 0;
		for(var c in this.thput){
			if(max < this.thput[c]){
				max = this.thput[c];
			}
		}
		var thput = [];
		for(var c in this.thput){
			thput.push((Math.floor((this.thput[c]/max)*100)));
		}
		document.getElementById("throughput").src = "http://chart.apis.google.com/chart?chtt=Throughput&cht=lc&chxt=y&chxl=0:||||||"+Math.round(max)+"char/s&chs=250x80&chd=t:"+thput.join(",");
		if(this.progMax != 0){
			document.getElementById("progBar").src = "http://chart.apis.google.com/chart?chs=250x300&cht=gom&chco=000055,772222&chd=t:"+Math.round(100 * this.count["all"] / this.progMax)+"&chl="+Math.round(100 * this.count["all"] / this.progMax)+"%";
		}
	},
	//----- Field
	count:{},
	startTime:0,
	endTime:0,
	intvl:15000,
	trig:15000,
	table:null,
	element:{},
	num:{},
	numA:{},
	ODD:true,
	strLen:0,
	thput:[],
	progMax:0
};

function start(){
	document.getElementById("start").innerHTML = "Loading...";

	var freddy = new Freddy.Parser.FreddyParser();
	var handler = new FreddyExampleHandler();
	freddy.setHandler(handler);
	freddy.parse(URL);
}
		</script>
	</head>
	<body>
		<div id="start">[<a href="#" onclick="start();return false">Start!</a>]</div>
		<div id="table"> </div>
		<div class="graph0">
			<img id="imgEleCount" src="http://chart.apis.google.com/chart?chs=350x190&cht=gom&chco=dd4444,7777ff&chd=t:15&chl=Hello+FREDDY+!"/>
			<img id="imgAttrCount" src="http://chart.apis.google.com/chart?chs=350x190&cht=gom&chco=dddd33,66ff66&chd=t:45&chl=Hello+FREDDY+!"/>
		</div>
		<div class="graph1">
			<img id="throughput" src="http://chart.apis.google.com/chart?chs=250x80&cht=gom&chco=FF2500,FFC500&chd=t:0&chl=Hello+FREDDY+!"/>
			<div id="result"><img id="progBar" src="http://chart.apis.google.com/chart?chs=250x300&cht=gom&chco=000033,332222&chd=t:75&chl=Hello+FREDDY+!"/></div>
		</div>
	</body>
</html>
EOF;
		$fp = fopen($Path.$Dir.$fileExample,"w");
		fwrite($fp,$example);
		fclose($fp);
	}
	if($FRONTEND){
		$pfe = fopen($Path.$Dir.$PhpFE,"w");
//-----------------------------------------------------------------------------------------------
		$tfFLAT = $FLAT ? "true" : "false";
		$tfHOLDINGS = $HOLDINGS ? "true" : "false";
		$tfVOLUME = $VOLUME ? "true" : "false";
		if($BENCHMARK){
			$benchmark = 'include($path.$fileBench);';
		}else{
			$benchmark = "header('Location: http://freddy.yokoyama.ac/');exit;";
		}
		if($EXAMPLE){
			$example    = 'include($path.$fileExample);';
		}else{
			$example = "header('Location: http://freddy.yokoyama.ac/');exit;";
		}
		$php = <<<EOF
<?php
\$path       = "./";

\$MaxPage     = $MaxPage;
\$FilePrefix  = "$FilePrefix";
\$Sep         = "$Sep";
\$Ext         = "$Ext";
\$freddyPAGE  = "$Ext";
\$freddyINDEX = "$ExtIdx";
\$FLAT        = $tfFLAT;
\$HOLDINGS    = $tfHOLDINGS;
\$VOLUME      = $tfVOLUME;
\$holdings    = "$FilePrefix$Ext";
\$fileBench   = "$fileBench";
\$fileExample = "$fileExample";

\$mime        = "application/javascript";
\$page        = null;

function getVolumu(\$page,\$vol=0){
	global \$MaxPage,\$FLAT;
	if(\$FLAT){
		return floor(\$page / \$MaxPage);
	}else{
		if(\$page <= \$vol){
			return \$vol;
		}else{
			if((\$vol+1) >= \$MaxPage){
				return floor(\$vol + (\$page/\$MaxPage));
			}else{
				return getVolumu(\$page - \$vol - 1,\$vol + 1);
			}
		}
	}
}

function getFile(\$page,\$ext){
	global \$path,\$FilePrefix,\$Sep;
	return \$FilePrefix.\$Sep.getVolumu(\$page).\$ext;
}

if(isset(\$_REQUEST["page"])){
	\$page = \$_REQUEST["page"];
}
if(!isset(\$_REQUEST["page"])){
	if(\$HOLDINGS){
		if(is_file(\$path.\$holdings)){
			header('Content-type: application/x-javascript');
			header("Content-Length: " . filesize(\$holdings));
			\$H = fopen(\$path.\$holdings,"r") or die("[ERROR(0)] ファイルのオープンに失敗しました");
			fpassthru(\$H);
		}else{
			header('Location: http://freddy.yokoyama.ac/');
		}
		exit;
	}
	\$page = 0;
}
if(is_numeric(\$page) and is_file(getFile(\$page,\$freddyPAGE))){
	\$page = intval(\$page);
	if(\$VOLUME and is_file(getFile(\$page,\$freddyINDEX))){
		\$IDX = fopen(getFile(\$page,\$freddyINDEX),"r") or die("[ERROR(1)] ファイルのオープンに失敗しました");
		header('Content-type: application/x-javascript');
		while ((\$line = fgetcsv(\$IDX)) !== FALSE) {
			\$p = intval(\$line[0]);
			if(\$p == \$page){
				\$start = intval(\$line[1]);
				\$nextLine = fgetcsv(\$IDX);
				\$end = intval(\$nextLine[1]);
				\$P = fopen(getFile(\$page,\$freddyPAGE),"r") or die("[ERROR(2)] ファイルのオープンに失敗しました");
				fseek(\$P,\$start);
				echo fread(\$P,\$end - \$start);
				exit;
			}
		}
	}else{
		if(is_file(\$path.\$FilePrefix.\$Sep."0".\$Ext)){
			header('Content-type: application/x-javascript');
			header("Content-Length: " . filesize(\$path.\$FilePrefix.\$Sep."0".\$Ext));
			\$H = fopen(\$path.\$FilePrefix.\$Sep."0".\$Ext,"r") or die("[ERROR(3)] ファイルのオープンに失敗しました");
			fpassthru(\$H);
		}else{
			header('Location: http://freddy.yokoyama.ac/');
		}
	}
}else{
	if(\$page == "benchmark"){
		$benchmark;
	}elseif(\$page == "example"){
		$example;
	}else{
		header('Location: http://freddy.yokoyama.ac/');
		exit;
	}
}
?>
EOF;
//-----------------------------------------------------------------------------------------------
		fwrite($pfe,$php);
		fclose($pfe);
	}
}

function stringTrueFalse($tf){
	if($tf){
		return "true";
	}else{
		return "false";
	}
}

function startElement($parser, $name, $attrs){
    global $out,$currentPage,$eventN,$ele,$NOCOMP;
	$eventN++;
	if(isset($ele[$name])){
		$ele[$name]++;
	}else{
		$ele[$name] = 1;
	}
	$newPage = getCurrentPageNum();
	if($currentPage != $newPage){
		switchNewFile();
	}
	if(!$NOCOMP){
		$compName = comp($name);
		if($compName == $name){
			fwrite($out, "s");
		}else{
			fwrite($out, "S");
		}
    	fwrite($out, "('".str_replace(",","\\,",$compName)."'");
	}else{
		fwrite($out, "('".str_replace(",","\\,",$name)."'");
	}
    if(count($attrs) != 0){
    	fwrite($out,",{");
			$att = Array();
			foreach($attrs as $k => $v){
				array_push($att,"'".escape($k)."':'".escape($v)."'");
			}
			fwrite($out,implode(",",$att));
		fwrite($out,"}");
    }
    fwrite($out,");");
}

function endElement($parser, $name){
    global $out,$currentPage,$eventN,$NOCOMP;
	$eventN++;
	$newPage = getCurrentPageNum();
	if($currentPage != $newPage){
		switchNewFile();
	}
	if(!$NOCOMP){
		fwrite($out,"e();");
	}else{
    	fwrite($out, "e('".escape($name)."');");
	}
}

function Characters($parser, $data){
    global $out,$currentPage,$eventN,$STRICT;
	if(!$STRICT){
		$data = trim($data);
	}
	if($data != ""){
		$eventN++;
		$newPage = getCurrentPageNum();
		if($currentPage != $newPage){
			switchNewFile();
		}
	    fwrite($out,"c('".escape($data)."');");
	}
}

$xml_parser = xml_parser_create();
xml_parser_set_option($xml_parser,XML_OPTION_CASE_FOLDING,0);
xml_set_element_handler($xml_parser, "startElement", "endElement");
xml_set_character_data_handler($xml_parser, "Characters");

if (!($fp =  fopen($InputFile, 'r'))) {
	die("XML 入力をオープンできませんでした: ".$InputFile);
}

while ($data = fread($fp, 4096)) {
    if (!xml_parse($xml_parser, $data, feof($fp))) {
        die(sprintf("XML エラー: %s が %d 行目で発生しました",
                    xml_error_string(xml_get_error_code($xml_parser)),
                    xml_get_current_line_number($xml_parser)));
    }
}
xml_parser_free($xml_parser);
finalize();
if(!$QUIET){
	echo "＜成功＞
	時間:       ".(microtime(true) - $startTime)." 秒
	イベント数: ".$eventN." 個

＜実装コード例＞
	var freddy = new Freddy.Parser.FreddyParser();
	var handler = new Freddy.Handler.CountEventHandler();
	freddy.setHandler(handler);
";
if($FRONTEND){
	echo '	freddy.parse("'.$Url.$Dir.$PhpFE.'");'."\n\n";
}elseif($HOLDINGS){
	echo '	freddy.parse("'.$Url.$Dir.$FilePrefix.$Ext.'");'."\n\n";
}else{
	echo '	freddy.parse("'.$Url.$Dir.$FilePrefix.$Sep."0".$Ext.'");'."\n\n";
}

	//foreach($ele as $name => $count){
	//	echo "$name\t$count\n";
	//}
}
if($BENCHMARK or $EXAMPLE){
	echo "＜サンプル・アプリケーション＞\n";
	if($EXAMPLE){
		echo "	実装例　: ".$Url.$Dir.$fileExample."\n";
		if($FRONTEND){
			echo "	        : ".$Url.$Dir.$PhpFE."?page=example\n";
		}
	}
	if($BENCHMARK){
		echo "	計時のみ: ".$Url.$Dir.$fileBench."\n";
		if($FRONTEND){
		echo "	        : ".$Url.$Dir.$PhpFE."?page=benchmark\n";
		}
	}
	echo "\n";
}
//php xml2freddy.php -I dataM.xml -N 15000 -F dataM_ -P ./html/freddy/data/ -D dataM -U http://supersonic.yokoyama.ac/freddy/data -OVERWRITE -VOLUME
?>